/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.BooleanLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.OpExpr;
import com.objectriver.compiler.exprs.OpType;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.runtime.things.Visitor;

public class MinExpr
extends OpExpr {
    public MinExpr(Expr left, Expr right) {
        super(left, OpType.valueOf("Min"), right);
        this.setType(ExprType.Min);
    }

    public String toString() {
        return "min(" + this.left.toString() + "," + this.right.toString() + ")";
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr leftEval = this.left.evaluate(thing);
        Expr rightEval = this.right.evaluate(thing);
        if (leftEval.getType() != ExprType.IntegerLiteral || rightEval.getType() != ExprType.IntegerLiteral) {
            throw new EvaluateExprException("Min expressions must evaluate to Integer Literals", this.getLexicalInfo());
        }
        IntegerLiteralExpr leftInt = (IntegerLiteralExpr)leftEval;
        if (leftInt.lessThan(rightEval) == BooleanLiteralExpr.True) {
            return leftEval;
        }
        return rightEval;
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfMinExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfMinExpr(this);
        return decend;
    }
}

