/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.runtime.things.Visitor;

public class NegateExpr
extends UnaryOpExpr {
    public NegateExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.Negate);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        if (!eval.isIntegerExpression()) {
            throw new EvaluateExprException("Operand of Negate must be Integer Expression", this.getLexicalInfo());
        }
        IntegerLiteralExpr intExpr = (IntegerLiteralExpr)eval;
        return intExpr.negate();
    }

    public String toString() {
        return "-" + this.operand.toString();
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfNegateExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfNegateExpr(this);
        return decend;
    }
}

