/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.BooleanLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.tokens.IntegerToken;
import com.objectriver.runtime.things.Visitor;

public class NotExpr
extends UnaryOpExpr {
    public NotExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.Not);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        if (eval.isIntegerExpression()) {
            IntegerLiteralExpr intExpr = (IntegerLiteralExpr)eval;
            IntegerToken intToken = (IntegerToken)intExpr.getValue();
            eval = intToken.intValue() == 0 ? BooleanLiteralExpr.False : BooleanLiteralExpr.True;
        } else if (!eval.isBooleanExpression()) {
            return BooleanLiteralExpr.False.not();
        }
        BooleanLiteralExpr boolExpr = (BooleanLiteralExpr)eval;
        return boolExpr.not();
    }

    public String toString() {
        return "!" + this.operand.toString();
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfNotExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfNotExpr(this);
        return decend;
    }
}

