/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.BooleanLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.OpType;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.lexinfo.LexicalInfo;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.asserts.Assert;

public abstract class OpExpr
extends Expr {
    protected Expr left;
    protected Expr right;
    protected final OpType operation;

    public OpExpr(Expr left, OpType op2, Expr right) {
        super(new LexicalInfo(left.getLexicalInfo()));
        this.operation = op2;
        this.left = left;
        this.right = right;
    }

    public Expr getLeft() {
        return this.left;
    }

    public void setLeft(Expr left) {
        this.left = left;
    }

    public Expr getRight() {
        return this.right;
    }

    public void setRight(Expr right) {
        this.right = right;
    }

    public OpType getOperation() {
        return this.operation;
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfOpExpr(this);
        if (decend &= v.beginVisitOfExpr(this)) {
            this.left.visit(visitor);
            this.right.visit(visitor);
        }
        v.endVisitOfExpr(this);
        v.endVisitOfOpExpr(this);
        return decend;
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr leftEval = this.left.evaluate(thing);
        Expr rightEval = this.right.evaluate(thing);
        IntegerLiteralExpr leftInteger = null;
        BooleanLiteralExpr leftBoolean = null;
        switch (this.operation.intValue()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                if (leftEval.getType() != ExprType.IntegerLiteral) {
                    throw new EvaluateExprException("Left side must be Integer Expression", this.getLexicalInfo());
                }
                leftInteger = (IntegerLiteralExpr)leftEval;
                break;
            }
            case 11: 
            case 12: {
                if (leftEval.getType() != ExprType.BooleanLiteral) {
                    throw new EvaluateExprException("Left side must be Boolean Expression", this.getLexicalInfo());
                }
                leftBoolean = (BooleanLiteralExpr)leftEval;
                break;
            }
            case 13: 
            case 19: {
                break;
            }
            default: {
                Assert.fail("Internal missing Op type");
            }
        }
        switch (this.operation.intValue()) {
            case 13: {
                if (leftEval.equals(rightEval)) {
                    return BooleanLiteralExpr.True;
                }
                return BooleanLiteralExpr.False;
            }
            case 19: {
                if (!leftEval.equals(rightEval)) {
                    return BooleanLiteralExpr.True;
                }
                return BooleanLiteralExpr.False;
            }
            case 15: {
                return leftInteger.greaterThan(rightEval);
            }
            case 18: {
                return leftInteger.greaterThanOrEqual(rightEval);
            }
            case 14: {
                return leftInteger.lessThan(rightEval);
            }
            case 17: {
                return leftInteger.lessThanOrEqual(rightEval);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return leftInteger.math(this.operation, rightEval);
            }
        }
        return null;
    }
}

