/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.StringUtility;

public class PatternExpr
extends UnaryOpExpr {
    public PatternExpr(Expr pattern) {
        super(pattern);
        this.setType(ExprType.Pattern);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        String pattern = StringUtility.removeQuotes(this.operand.toString());
        while (pattern.indexOf("\\\\") != -1) {
            pattern = pattern.replace("\\\\", "\\");
        }
        return new IdentifierExpr(new IdentifierToken(pattern, this.operand.getLexicalInfo()));
    }

    public String toString() {
        return "pattern( " + this.operand.toString() + "\")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfPatternExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfPatternExpr(this);
        return decend;
    }
}

