/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.runtime.things.Visitor;

public class PostDecrementExpr
extends UnaryOpExpr {
    public PostDecrementExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.PostDecrement);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        if (!eval.isIntegerExpression()) {
            throw new EvaluateExprException("Operand of Post Decrement must be Integer Expression", this.getLexicalInfo());
        }
        IntegerLiteralExpr intExpr = (IntegerLiteralExpr)eval;
        return intExpr.decrement();
    }

    public String toString() {
        return this.operand + "--";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfPostDecrementExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfPostDecrementExpr(this);
        return decend;
    }
}

