/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.NullLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.tokens.IntegerToken;
import com.objectriver.runtime.things.Visitor;
import java.util.Random;

public class RandomExpr
extends UnaryOpExpr {
    private Random random = null;

    public RandomExpr(Expr seed) {
        super(seed);
        this.setType(ExprType.Random);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        if (this.random == null) {
            if (this.operand == NullLiteralExpr.Null) {
                this.random = new Random();
            } else {
                if (eval.getType() != ExprType.IntegerLiteral) {
                    throw new EvaluateExprException("Randon seed must evaluate Integer Literal Expression", this.getLexicalInfo());
                }
                IntegerToken seed = (IntegerToken)((IntegerLiteralExpr)eval).getValue();
                this.random = new Random(seed.longValue());
            }
        }
        long randomValue = this.random.nextLong();
        return new IntegerLiteralExpr(new IntegerToken(randomValue, Long.toString(randomValue), eval.getLexicalInfo()));
    }

    public String toString() {
        return "random( " + this.operand.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfRandomExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfRandomExpr(this);
        return decend;
    }
}

