/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.StringUtility;

public class ReplaceExpr
extends UnaryOpExpr {
    protected final Expr thisstr;
    protected final Expr withthis;
    protected boolean replaceFirst = false;
    protected boolean replaceAll = false;

    public ReplaceExpr(Expr operand, Expr thisstr, Expr withthis) {
        super(operand);
        this.thisstr = thisstr;
        this.withthis = withthis;
        this.setType(ExprType.Replace);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        Expr this_eval = this.thisstr.evaluate(thing);
        Expr withthis_eval = this.withthis.evaluate(thing);
        String this_str = StringUtility.removeQuotes(this_eval.toString());
        String withthis_str = StringUtility.removeQuotes(withthis_eval.toString());
        switch (eval.getType().intValue()) {
            case 30: {
                String replaced = this.replaceFirst ? eval.toString().replaceFirst(this_str, withthis_str) : (this.replaceAll ? eval.toString().replaceAll(this_str, withthis_str) : eval.toString().replace(this_str, withthis_str));
                return new IdentifierExpr(new IdentifierToken(replaced, this.operand.getLexicalInfo()));
            }
            case 24: {
                String replaced = this.replaceFirst ? eval.toString().replaceFirst(this_str, withthis_str) : (this.replaceAll ? eval.toString().replaceAll(this_str, withthis_str) : eval.toString().replace(this_str, withthis_str));
                return new StringLiteralExpr(new StringToken(replaced, this.operand.getLexicalInfo()));
            }
        }
        throw new EvaluateExprException("Replace must operate on Literal String or Identifier Expression", this.getLexicalInfo());
    }

    public void setReplaceFirst(boolean replaceFirst) {
        this.replaceFirst = replaceFirst;
    }

    public void setReplaceAll(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }

    public String toString() {
        return "replace( " + this.operand.toString() + ",\"" + this.thisstr + "\",\"" + this.withthis + "\")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfReplaceExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfReplaceExpr(this);
        return decend;
    }
}

