/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.CharacterLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.LiteralExpr;
import com.objectriver.compiler.exprs.tmpl.TmplTokenLiteralExpr;
import com.objectriver.compiler.lexinfo.LexicalInfo;
import com.objectriver.compiler.tokens.CharacterToken;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.runtime.things.Visitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScopedNameExpr
extends Expr {
    private LinkedList scopednames = new LinkedList();

    public ScopedNameExpr(Expr node) {
        super(node.getLexicalInfo());
        this.scopednames.add(node);
        this.setType(ExprType.ScopedName);
    }

    public void addName(Expr node) {
        this.scopednames.addLast(node);
    }

    public boolean isIdentifier() {
        return this.scopednames.size() == 1 && this.scopednames.getFirst() instanceof IdentifierExpr;
    }

    public Expr getFirst() {
        return (Expr)this.scopednames.getFirst();
    }

    public Expr getLast() {
        return (Expr)this.scopednames.getLast();
    }

    public int getSize() {
        return this.scopednames.size();
    }

    public Iterator iterator() {
        return this.scopednames.iterator();
    }

    @Override
    public Expr evaluate(CtThing thing1) {
        Iterator iter = this.scopednames.iterator();
        StringBuffer value = new StringBuffer(64);
        while (iter.hasNext()) {
            Expr node = ((Expr)iter.next()).evaluate(thing1);
            value.append(node.toString());
        }
        return new IdentifierExpr(new IdentifierToken(value.toString(), this.getLexicalInfo()));
    }

    public String toString() {
        Iterator iter = this.scopednames.iterator();
        StringBuffer value = new StringBuffer(64);
        while (iter.hasNext()) {
            Expr node = (Expr)iter.next();
            value.append(node.toString());
        }
        return value.toString();
    }

    public String toString(char separator) {
        Iterator iter = this.scopednames.iterator();
        StringBuffer value = new StringBuffer(64);
        while (iter.hasNext()) {
            Expr node = (Expr)iter.next();
            value.append(node.toString());
            if (!iter.hasNext()) continue;
            value.append(separator);
        }
        return value.toString();
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        if (decend &= v.beginVisitOfScopedNameExpr(this)) {
            Iterator iter = this.scopednames.iterator();
            while (iter.hasNext()) {
                ((Expr)iter.next()).acceptVisit(visitor, decend);
            }
        }
        v.endVisitOfScopedNameExpr(this);
        return decend;
    }

    public static ScopedNameExpr valueOf(String name, String separator, LexicalInfo lexInfo) {
        CharacterLiteralExpr separatorExpr = new CharacterLiteralExpr(new CharacterToken(separator.charAt(0), separator, lexInfo));
        ArrayList<String> piecesList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(%%[\\w.]*%%)|([\\w]*)");
        Matcher matcher = pattern.matcher(name);
        while (matcher.find()) {
            if (matcher.group().equals("")) continue;
            piecesList.add(matcher.group());
        }
        Iterator iter = piecesList.iterator();
        ScopedNameExpr scopeNameExpr = null;
        LiteralExpr scopeNamePieceExpr = null;
        boolean first = true;
        while (iter.hasNext()) {
            String piece = (String)iter.next();
            if (piece.contains("%%")) {
                String middle = piece.substring(2, piece.length() - 2);
                String[] parts = middle.split("[.]");
                IdentifierToken node = new IdentifierToken(parts[0], lexInfo);
                IdentifierToken method = new IdentifierToken(parts.length == 1 ? "name" : parts[1], lexInfo);
                scopeNamePieceExpr = new TmplTokenLiteralExpr(node, method);
            } else {
                scopeNamePieceExpr = new IdentifierExpr(new IdentifierToken(piece, lexInfo));
            }
            if (first) {
                first = false;
                scopeNameExpr = new ScopedNameExpr(scopeNamePieceExpr);
            } else {
                scopeNameExpr.addName(scopeNamePieceExpr);
            }
            if (!iter.hasNext()) continue;
            scopeNameExpr.addName(separatorExpr);
        }
        return scopeNameExpr;
    }

    public static void main(String[] args) {
        String name = "%%a.b%%.%%aa%%.a.b.%%$fred%%";
        Pattern pattern = Pattern.compile("(%%[\\w.]*%%)|([\\w]*)");
        Matcher matcher = pattern.matcher(name);
        while (matcher.find()) {
            if (matcher.group().equals("")) continue;
            System.out.println(matcher.start() + matcher.group());
        }
    }
}

