/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.CharStringLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.tokens.CharStringToken;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.StringUtility;

public class SingleQuoteExpr
extends UnaryOpExpr {
    public SingleQuoteExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.SingleQuote);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        String evalString = StringUtility.removeQuotes(eval.toString());
        return new CharStringLiteralExpr(new CharStringToken("'" + evalString + "'", this.getLexicalInfo()));
    }

    public String toString() {
        return "singlequote( " + this.operand.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfSingleQuoteExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfSingleQuoteExpr(this);
        return decend;
    }
}

