/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.BooleanLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.StringUtility;

public class StartsWithExpr
extends UnaryOpExpr {
    protected final Expr prefixExpr;

    public StartsWithExpr(Expr operand, Expr startsWith) {
        super(operand);
        this.prefixExpr = startsWith;
        this.setType(ExprType.SubString);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr targetToken = this.operand.evaluate(thing);
        String prefix = null;
        switch (this.prefixExpr.getType().intValue()) {
            case 30: {
                prefix = this.prefixExpr.toString();
                break;
            }
            case 24: 
            case 44: {
                prefix = StringUtility.removeQuotes(this.prefixExpr.toString());
            }
        }
        switch (targetToken.getType().intValue()) {
            case 30: {
                String target = targetToken.toString();
                if (target.startsWith(prefix)) {
                    return BooleanLiteralExpr.True;
                }
                return BooleanLiteralExpr.False;
            }
            case 24: 
            case 44: {
                String target = StringUtility.removeQuotes(targetToken.toString());
                if (target.startsWith(prefix)) {
                    return BooleanLiteralExpr.True;
                }
                return BooleanLiteralExpr.False;
            }
        }
        throw new EvaluateExprException("SubString must operate on Literal String or Identifier Expression", this.getLexicalInfo());
    }

    public String toString() {
        return "startswith(" + this.operand.toString() + "," + this.prefixExpr.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfStartsWithExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfStartsWithExpr(this);
        return decend;
    }
}

