/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.attribute.AttributeStringifier;
import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.LiteralExpr;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.compiler.tokens.TkToken;
import com.objectriver.runtime.things.Visitor;

public class StringLiteralExpr
extends LiteralExpr {
    private final AttributeStringifier line;

    public StringLiteralExpr(StringToken value) {
        super(value);
        this.setType(ExprType.StringLiteral);
        this.line = new AttributeStringifier((TkToken)value);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        if (this.line.anyAttributes()) {
            return new StringLiteralExpr(new StringToken(this.line.stringify(thing), this.value.getLexicalInfo()));
        }
        return this;
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfStringLiteralExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfStringLiteralExpr(this);
        return decend;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringLiteralExpr)) {
            return false;
        }
        StringLiteralExpr stringLiteralExpr = (StringLiteralExpr)o;
        return !(this.value != null ? !this.value.equals(stringLiteralExpr.value) : stringLiteralExpr.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

