/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.CharStringLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.tokens.CharStringToken;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.compiler.tokens.IntegerToken;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.StringUtility;

public class SubStringExpr
extends UnaryOpExpr {
    protected final IntegerToken start;
    protected final IntegerToken end;

    public SubStringExpr(Expr operand, IntegerLiteralExpr start, IntegerLiteralExpr end) {
        super(operand);
        this.start = (IntegerToken)start.value;
        this.end = (IntegerToken)end.value;
        this.setType(ExprType.SubString);
    }

    public SubStringExpr(Expr operand, IntegerLiteralExpr start) {
        super(operand);
        this.start = (IntegerToken)start.value;
        this.end = null;
        this.setType(ExprType.SubString);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr targetToken = this.operand.evaluate(thing);
        switch (targetToken.getType().intValue()) {
            case 30: {
                String target = targetToken.toString();
                target = this.end != null ? target.substring(this.start.intValue(), this.end.intValue()) : target.substring(this.start.intValue());
                return new IdentifierExpr(new IdentifierToken(target, this.operand.getLexicalInfo()));
            }
            case 24: {
                String target = StringUtility.removeQuotes(targetToken.toString());
                target = this.end != null ? target.substring(this.start.intValue(), this.end.intValue()) : target.substring(this.start.intValue());
                return new StringLiteralExpr(new StringToken("\"" + target + "\"", this.operand.getLexicalInfo()));
            }
            case 44: {
                String target = StringUtility.removeQuotes(targetToken.toString());
                target = this.end != null ? target.substring(this.start.intValue(), this.end.intValue()) : target.substring(this.start.intValue());
                return new CharStringLiteralExpr(new CharStringToken("'" + target + "'", this.operand.getLexicalInfo()));
            }
        }
        throw new EvaluateExprException("SubString must operate on Literal String or Identifier Expression", this.getLexicalInfo());
    }

    public String toString() {
        return "substring(" + this.operand.toString() + "," + this.start.toString() + "," + this.end.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfSubStringExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfSubStringExpr(this);
        return decend;
    }
}

