/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.compiler.tokens.IntegerToken;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.StringUtility;

public class TruncateExpr
extends UnaryOpExpr {
    private final Expr length;

    public TruncateExpr(Expr operand, Expr length) {
        super(operand);
        this.setType(ExprType.Truncate);
        this.length = length;
    }

    public Expr getLength() {
        return this.length;
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr lengthEval = this.length.evaluate(thing);
        Expr eval = this.operand.evaluate(thing);
        if (lengthEval.getType() != ExprType.IntegerLiteral) {
            throw new EvaluateExprException("Truncate length must evaluate Integer Literal Expression", this.getLexicalInfo());
        }
        int size = ((IntegerToken)((IntegerLiteralExpr)lengthEval).getValue()).intValue();
        String evalString = eval.toString();
        if (evalString.length() <= size) {
            return eval;
        }
        switch (eval.getType().intValue()) {
            case 10: {
                String truncated = evalString.substring(0, size - 1);
                long newlong = Long.parseLong(truncated);
                return new IntegerLiteralExpr(new IntegerToken(newlong, truncated, eval.getLexicalInfo()));
            }
            case 24: {
                String tmp = evalString.substring(1, evalString.length() - 1);
                if (tmp.length() < size) {
                    return eval;
                }
                tmp = tmp.substring(0, size);
                return new StringLiteralExpr(new StringToken(StringUtility.stringQuoter(tmp), eval.getLexicalInfo()));
            }
            case 30: {
                if (evalString.length() < size) {
                    return eval;
                }
                return new IdentifierExpr(new IdentifierToken(evalString.substring(0, size), eval.getLexicalInfo()));
            }
        }
        return eval;
    }

    public String toString() {
        return "truncate( " + this.operand.toString() + "," + this.length.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfTruncateExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfTruncateExpr(this);
        return decend;
    }
}

