/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.runtime.things.Visitor;

public class UpperCaseExpr
extends UnaryOpExpr {
    public UpperCaseExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.UpperCase);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        switch (eval.getType().intValue()) {
            case 24: {
                return new StringLiteralExpr(new StringToken(eval.toString().toUpperCase(), eval.getLexicalInfo()));
            }
            case 30: {
                return new IdentifierExpr(new IdentifierToken(eval.toString().toUpperCase(), eval.getLexicalInfo()));
            }
        }
        throw new EvaluateExprException("UpperCase needs to operate on String or Identifier  Expression", this.getLexicalInfo());
    }

    public String toString() {
        return "uppercase( " + this.operand.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfUpperCaseExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfUpperCaseExpr(this);
        return decend;
    }
}

