/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs.rest;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.runtime.things.Visitor;

public class PathParamFormatExpr
extends UnaryOpExpr {
    public PathParamFormatExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.PathParamFormat);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        switch (eval.getType().intValue()) {
            case 24: {
                String path = eval.toString().replaceAll("[{][-\\w]+[}]", "%s");
                return new StringLiteralExpr(new StringToken(path, eval.getLexicalInfo()));
            }
            case 30: {
                String path = eval.toString().replaceAll("[{][-\\w]+[}]", "%s");
                return new IdentifierExpr(new IdentifierToken(path, eval.getLexicalInfo()));
            }
        }
        throw new EvaluateExprException("PathParamFormatExpr needs to operate on String or Identifier  Expression", this.getLexicalInfo());
    }

    public String toString() {
        return "pathparam_format( " + this.operand.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfPathParamFormatExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfPathParamFormatExpr(this);
        return decend;
    }
}

