/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs.tmpl;

import com.objectriver.compiler.be.instructions.abstracts.BeScope;
import com.objectriver.compiler.be.misc.BeStackSingleton;
import com.objectriver.compiler.be.things.BeVariable;
import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.ct.things.Scope;
import com.objectriver.compiler.exprs.BooleanLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.NullLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.SemanticError;
import com.objectriver.compiler.lang.SemanticException;
import com.objectriver.runtime.things.Visitor;

public class DefinedExpr
extends UnaryOpExpr {
    private Scope scopeSeen = null;

    public DefinedExpr(Expr identifier) {
        super(identifier);
        this.type = ExprType.Defined;
    }

    public void setScopeSeen(Scope scopeSeen) {
        this.scopeSeen = scopeSeen;
    }

    public String toString() {
        return "defined( " + this.operand.toString() + ")";
    }

    @Override
    public Expr evaluate(CtThing thing) {
        IdentifierExpr identifier;
        Expr eval = this.operand.evaluate(thing);
        if (eval.getType() != ExprType.IdentifierLiteral) {
            throw new SemanticException(new SemanticError("defined(identifier)", "defined() function requires Identifer expression!", this.operand.getLexicalInfo()));
        }
        BeScope scope = (BeScope)BeStackSingleton.getInstance().getStack().iterator(BeScope.class).next();
        BeVariable variable = (BeVariable)scope.lookup((identifier = (IdentifierExpr)this.operand).getValue(), BeVariable.class, true);
        if (variable != null && variable.getValue() == NullLiteralExpr.Null) {
            return BooleanLiteralExpr.False;
        }
        if (variable == null) {
            return BooleanLiteralExpr.False;
        }
        return BooleanLiteralExpr.True;
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfDefinedExpr(this);
        v.endVisitOfExpr(this);
        v.endVisitOfDefinedExpr(this);
        return decend &= v.beginVisitOfExpr(this);
    }
}

