/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs.tmpl;

import com.objectriver.compiler.be.instructions.abstracts.BeInstruction;
import com.objectriver.compiler.be.instructions.abstracts.BeScope;
import com.objectriver.compiler.be.misc.BeStackSingleton;
import com.objectriver.compiler.be.things.BeThingReference;
import com.objectriver.compiler.be.things.BeVariable;
import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprCurrentScopeSingleton;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.LiteralExpr;
import com.objectriver.compiler.lang.SemanticError;
import com.objectriver.compiler.lang.SemanticException;
import com.objectriver.compiler.tokens.TkToken;
import com.objectriver.runtime.things.Visitor;

public class TmplVariableLiteralExpr
extends LiteralExpr {
    private final BeThingReference variableRef;

    public TmplVariableLiteralExpr(TkToken node) {
        super(node);
        ExprCurrentScopeSingleton current = ExprCurrentScopeSingleton.getInstance();
        BeScope scope = (BeScope)current.getScope();
        this.variableRef = new BeThingReference(node, scope, null);
        this.setType(ExprType.SpecialLiteral);
    }

    @Override
    public Expr evaluate(CtThing thing1) {
        BeVariable variable = (BeVariable)this.variableRef.resolve(BeVariable.class, true);
        if (variable == null) {
            BeInstruction instruction = BeStackSingleton.getInstance().getStack().peek();
            SemanticError error = new SemanticError("Template", "Variable " + this.variableRef.getName().toString() + " is not defined?", instruction.getLexicalInfo());
            throw new SemanticException(new SemanticError[]{error});
        }
        return variable.getValue().evaluate(thing1);
    }

    @Override
    public String toString() {
        return "%%$" + this.value.toString() + "%%";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfTmplVariableLiteralExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfTmplVariableLiteralExpr(this);
        return decend;
    }
}

