/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.lexinfo;

import com.objectriver.compiler.lexinfo.LexicalInfo;

public class LexicalInfoSingleton {
    public String filename;
    public int lineNumber;
    public boolean imported;
    private int importNesting = 0;
    private static final ThreadLocal<LexicalInfoSingleton> ourInstance = new ThreadLocal<LexicalInfoSingleton>(){

        @Override
        protected LexicalInfoSingleton initialValue() {
            return new LexicalInfoSingleton();
        }
    };

    private LexicalInfoSingleton() {
    }

    public static LexicalInfoSingleton getInstance() {
        return ourInstance.get();
    }

    public LexicalInfo getLexicalInfo() {
        return new LexicalInfo(this.filename, this.lineNumber, this.imported);
    }

    public void beginImport() {
        this.imported = true;
        ++this.importNesting;
    }

    public void endImport() {
        if (--this.importNesting == 0) {
            this.imported = false;
        }
    }

    public void setLexicalInfo(String filename, int lineNumber) {
        this.filename = filename;
        this.lineNumber = lineNumber;
    }

    public void setLexicalInfo(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void incrementLineNumber() {
        ++this.lineNumber;
    }

    public void clearLexicalInfo() {
        this.filename = null;
        this.lineNumber = 0;
        this.imported = false;
        this.importNesting = 0;
    }
}

