/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.tokens;

import com.objectriver.compiler.lexinfo.LexicalInfo;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.compiler.tokens.TkToken;
import com.objectriver.compiler.tokens.TokenType;
import com.objectriver.runtime.util.StringUtility;
import com.objectriver.runtime.util.asserts.Assert;

public class IntegerToken
extends TkToken {
    private long value;

    public IntegerToken(long value, String lexString, LexicalInfo lexInfo) {
        super(lexString, lexInfo);
        this.value = value;
    }

    public IntegerToken(StringToken token) {
        super(StringUtility.removeQuotes(token.toString()), token.getLexicalInfo());
        try {
            Long longclass = new Long(super.toString());
            this.value = longclass;
        }
        catch (NumberFormatException nfe) {
            Assert.fail("Bad integer token " + super.toString() + " " + token.getLexicalInfo().toString());
        }
    }

    @Override
    public TokenType getType() {
        return TokenType.IntegerToken;
    }

    public long longValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }
}

