/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.util;

import com.objectriver.runtime.util.FileHelper;
import java.io.File;
import java.io.FileNotFoundException;

public class FileName
extends File {
    private String baseName;
    private String extension;
    private String name;
    private boolean isConstructed = false;

    public FileName(String file) {
        super(file);
        this.construct();
    }

    public FileName(File file) {
        super(file.getPath());
        this.construct();
    }

    private void construct() {
        File goodCase = null;
        if (this.exists()) {
            try {
                goodCase = FileHelper.getCaseInsensitiveFile(this);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            goodCase = this;
        }
        this.baseName = FileHelper.getBasename(goodCase);
        this.extension = FileHelper.getExtension(goodCase);
        this.name = this.extension == null ? this.baseName : this.baseName + "." + this.extension;
        this.isConstructed = true;
    }

    @Override
    public String getName() {
        if (this.isConstructed) {
            return this.name;
        }
        return super.getName();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getExtension() {
        return this.extension;
    }
}

