/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.util.resource;

import com.objectriver.compiler.util.resource.JsonPath;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.util.resource.JarResource;
import com.objectriver.runtime.util.resource.Resource;
import com.objectriver.runtime.util.resource.ResourceType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;

public class JsonResource
implements Resource {
    private URL url;
    private URLConnection jsonConn;
    private JsonPath jsonPath = null;
    private final ResourceType type = ResourceType.Json;
    private Reader reader = null;

    public JsonResource(URL url) {
        this.url = url;
        String string = url.toString();
        Assert.assertTrue("Invalid URL for Jar: " + string, string.startsWith("jar:"));
        try {
            this.jsonConn = url.openConnection();
        }
        catch (IOException e) {
            Assert.fail("Bad URL resource: " + string);
        }
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public ResourceType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        String name = this.url.toString();
        int begin = name.lastIndexOf(47);
        return name.substring(begin + 1);
    }

    @Override
    public String getPath() {
        return this.url.toString();
    }

    @Override
    public Resource addToPath(String member) {
        return null;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean memberExists(String member) {
        return false;
    }

    @Override
    public Resource getMember(String member) {
        return null;
    }

    @Override
    public Resource getMember(String path, String member) {
        return null;
    }

    @Override
    public Iterator iterateMembers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource getParent() {
        try {
            int bang;
            int end;
            StringBuffer buff = new StringBuffer(this.url.toString());
            if (buff.toString().endsWith("/")) {
                buff.deleteCharAt(buff.length() - 1);
            }
            if ((end = buff.lastIndexOf("/")) >= (bang = buff.indexOf("!"))) {
                return new JarResource(new URL(buff.substring(0, end)));
            }
            Assert.fail("Internal Error");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            Assert.fail("Internal Error");
        }
        return null;
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public Reader getReader() throws IOException {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public BufferedReader getBufferedReader() throws IOException {
        return new BufferedReader(this.getReader());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.jsonConn.getInputStream();
    }
}

