/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.ArgMask;
import com.objectriver.runtime.primitives.BitMaskImpl;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.util.BitSet;

public class ArgMaskImpl
extends BitMaskImpl
implements ArgMask {
    public ArgMaskImpl(int nbits) {
        super(nbits);
    }

    public static ArgMask valueOf(BitSet bits) {
        ArgMaskImpl impl = new ArgMaskImpl(bits.length());
        int nbits = bits.length();
        for (int ii = 1; ii < nbits; ++ii) {
            if (!bits.get(ii)) continue;
            int n = (ii - 1) / 8;
            impl.bytes[n] = (byte)(impl.bytes[n] ^ 1 << (ii - 1) % 8);
        }
        return impl;
    }

    @Override
    public String getTypeName() {
        return "ArgMask";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfArgMask", ArgMask.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return true;
    }
}

