/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.BitMask;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.StringFactory;
import com.objectriver.runtime.primitives.abstracts.AbstractPrimitiveString;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.util.BitSet;

public abstract class BitMaskImpl
extends AbstractPrimitiveString
implements BitMask {
    protected byte[] bytes;

    protected BitMaskImpl(int maxBits) {
        super("", 1 + maxBits / 4, PrimitiveType.VarChar);
        this.bytes = new byte[maxBits / 8 + 1];
    }

    protected BitMaskImpl(String value, int maxSize) {
        super(StringFactory.valueOf(value), maxSize, PrimitiveType.VarChar);
    }

    protected BitMaskImpl(String value) {
        super(value, 50, PrimitiveType.VarChar);
    }

    @Override
    public boolean isSet(int index) {
        int bitNumber;
        return (this.bytes[--index / 8] & (bitNumber = 1 << index % 8)) != 0;
    }

    @Override
    public BitSet getBits() {
        int highestbyte = this.getHighestByte();
        BitSet bits = new BitSet();
        for (int bb = 0; bb <= highestbyte; ++bb) {
            byte b = this.bytes[bb];
            if ((b & 1) != 0) {
                bits.set(bb * 8 + 1);
            }
            if ((b & 2) != 0) {
                bits.set(bb * 8 + 2);
            }
            if ((b & 4) != 0) {
                bits.set(bb * 8 + 3);
            }
            if ((b & 8) != 0) {
                bits.set(bb * 8 + 4);
            }
            if ((b & 0x10) != 0) {
                bits.set(bb * 8 + 5);
            }
            if ((b & 0x20) != 0) {
                bits.set(bb * 8 + 6);
            }
            if ((b & 0x40) != 0) {
                bits.set(bb * 8 + 7);
            }
            if ((b & 0x80) == 0) continue;
            bits.set(bb * 8 + 8);
        }
        return bits;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(50);
        int highestbyte = this.getHighestByte();
        for (int ii = 0; ii <= highestbyte; ++ii) {
            buffer.append(this.byteToHex(this.bytes[ii]));
        }
        return buffer.toString();
    }

    public String byteToHex(byte b) {
        int i = b & 0xFF;
        String tmp = Integer.toHexString(i);
        if (tmp.length() == 1) {
            return '0' + tmp;
        }
        return tmp;
    }

    @Override
    public boolean isEmpty() {
        for (int ii = 0; ii < this.bytes.length; ++ii) {
            if (this.bytes[ii] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int length() {
        int hb = this.getHighestByte();
        byte b = this.bytes[hb];
        if ((b & 0x80) != 0) {
            return hb * 8 + 8;
        }
        if ((b & 0x40) != 0) {
            return hb * 8 + 7;
        }
        if ((b & 0x20) != 0) {
            return hb * 8 + 6;
        }
        if ((b & 0x10) != 0) {
            return hb * 8 + 5;
        }
        if ((b & 8) != 0) {
            return hb * 8 + 4;
        }
        if ((b & 4) != 0) {
            return hb * 8 + 3;
        }
        if ((b & 2) != 0) {
            return hb * 8 + 2;
        }
        if ((b & 1) != 0) {
            return hb * 8 + 1;
        }
        Assert.fail();
        return 0;
    }

    protected void fromString(String hexString) {
        this.clearBytes();
        int len = (hexString.length() + 1) / 2;
        int bb = 0;
        int ii = 0;
        if (hexString.length() % 2 == 1) {
            this.bytes[bb] = this.lowDigit(hexString.charAt(ii));
            ++bb;
            ++ii;
        }
        while (bb < len) {
            this.bytes[bb] = this.highDigit(hexString.charAt(ii));
            if (ii + 1 < hexString.length()) {
                int n = bb;
                this.bytes[n] = (byte)(this.bytes[n] ^ this.lowDigit(hexString.charAt(ii + 1)));
            }
            ii += 2;
            ++bb;
        }
    }

    private void clearBytes() {
        for (int ii = 0; ii < this.bytes.length; ++ii) {
            this.bytes[ii] = 0;
        }
    }

    protected int getHighestByte() {
        int highestbyte = 0;
        for (int ii = this.bytes.length - 1; ii >= 0; --ii) {
            if (this.bytes[ii] == 0) continue;
            highestbyte = ii;
            break;
        }
        return highestbyte;
    }

    private byte highDigit(char b) {
        return (byte)(this.digit(b) << 4);
    }

    private byte lowDigit(char b) {
        return this.digit(b);
    }

    private byte digit(char c) {
        return (byte)Character.digit(c, 16);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BitMask)) {
            return false;
        }
        BitMask other = (BitMask)object;
        return this.getBits().equals(other.getBits());
    }

    @Override
    public String getTypeName() {
        return "BitMask";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            if (decend) {
                Method method = visitor.getClass().getMethod("visitOfBitMask", BitMask.class);
                method.invoke((Object)visitor, this);
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            System.err.println("Visitor class access error. Vistor " + visitor.getClass().toString() + " may be nested or non-public!");
            Assert.fail("IllegalAccessException: " + e.getMessage());
        }
        catch (Exception e) {
            String message = "Internal Error: ";
            if (e != null) {
                message = message + e.getMessage();
            }
            Assert.fail(message);
        }
        return decend;
    }
}

