/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.VarBinary;
import com.objectriver.runtime.primitives.abstracts.AbstractPrimitiveVarBinary;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;

public class BlobImpl
extends AbstractPrimitiveVarBinary
implements VarBinary {
    protected byte[] bytes;

    public BlobImpl(byte[] bytes) {
        super(bytes, bytes.length, PrimitiveType.Blob);
        this.bytes = bytes;
    }

    @Override
    public String getTypeName() {
        return "Blob";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            if (decend) {
                Method method = visitor.getClass().getMethod("visitOfClob", VarBinary.class);
                method.invoke((Object)visitor, this);
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            System.err.println("Visitor class access error. Vistor " + visitor.getClass().toString() + " may be nested or non-public!");
            Assert.fail("IllegalAccessException: " + e.getMessage());
        }
        catch (Exception e) {
            String message = "Internal Error: ";
            if (e != null) {
                message = message + e.getMessage();
            }
            Assert.fail(message);
        }
        return decend;
    }
}

