/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.StringConst;
import com.objectriver.runtime.util.StringUtility;

public class BooleanFactory {
    public static final String TrueString = "T";
    public static final String FalseString = "F";

    public static Boolean valueOf(Boolean value) {
        return value;
    }

    public static Boolean valueOf(boolean value) {
        if (value) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean valueOf(int value) {
        if (value == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean valueOf(char value) {
        if (value == 'T' || value == 't') {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean[] valueOf(boolean[] values) {
        Boolean[] result = new Boolean[values.length];
        for (int ii = 0; ii < values.length; ++ii) {
            result[ii] = BooleanFactory.valueOf(values[ii]);
        }
        return result;
    }

    public static Boolean valueOf(String value) {
        if (value == null) {
            return null;
        }
        if (value.equals(TrueString)) {
            return Boolean.TRUE;
        }
        if (value.equals(FalseString)) {
            return Boolean.FALSE;
        }
        if (StringUtility.isInteger(value)) {
            long number = Long.parseLong(value);
            if (number == 0L) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase(StringConst.True)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String getPersistentString(boolean boolVar) {
        return boolVar ? TrueString : FalseString;
    }
}

