/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.PrimitiveEnumeration;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.abstracts.AbstractEnumeration;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.StringUtility;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;

public final class Cardinality
extends AbstractEnumeration
implements PrimitiveEnumeration {
    public static final String typeName = "Cardinality";
    private static final String[] _menu = new String[]{"root", "1..1", "0..1", "1..*", "0..*"};
    public static final int RootInt = 1;
    public static final Cardinality Root = new Cardinality(_menu[0], 1, _menu[0]);
    public static final int OneToOneInt = 2;
    public static final Cardinality OneToOne = new Cardinality(_menu[1], 2, _menu[1]);
    public static final int ZeroToOneInt = 3;
    public static final Cardinality ZeroToOne = new Cardinality(_menu[2], 3, _menu[2]);
    public static final int OneToManyInt = 4;
    public static final Cardinality OneToMany = new Cardinality(_menu[3], 4, _menu[3]);
    public static final int ZeroToManyInt = 5;
    public static final Cardinality ZeroToMany = new Cardinality(_menu[4], 5, _menu[4]);
    private static final HashMap hashMap = new HashMap(_menu.length);
    private static final Cardinality[] instances;

    public static String[] getMenu() {
        return _menu;
    }

    public static String[] getDescriptions() {
        return _menu;
    }

    public static Cardinality[] getInstances() {
        return instances;
    }

    private Cardinality(String name, int number, String description) {
        super(name, number, description, 2, PrimitiveType.Enumeration);
    }

    @Override
    public PrimitiveEnumeration instanceOf(int enumvalue) {
        return Cardinality.valueOf(enumvalue);
    }

    @Override
    public PrimitiveEnumeration instanceOf(String string) {
        return Cardinality.valueOf(string);
    }

    public static Cardinality valueOf(int enumvalue) {
        switch (enumvalue) {
            case 1: {
                return Root;
            }
            case 2: {
                return OneToOne;
            }
            case 3: {
                return ZeroToOne;
            }
            case 4: {
                return OneToMany;
            }
            case 5: {
                return ZeroToMany;
            }
        }
        return null;
    }

    public static Cardinality valueOf(String string) {
        Object enumobject = hashMap.get(string);
        if (enumobject == null && StringUtility.isInteger(string)) {
            return Cardinality.valueOf(Integer.parseInt(string));
        }
        return (Cardinality)enumobject;
    }

    @Override
    public Iterator iterator() {
        return new ArrayIterator(instances);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String getTypeName() {
        return typeName;
    }

    @Override
    protected boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfCardinality", Cardinality.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return decend;
    }

    public Cardinality valueOfDescription(String description) {
        return Cardinality.valueOf(description);
    }

    static {
        hashMap.put(_menu[0], Root);
        hashMap.put("Root", Root);
        hashMap.put("/", Root);
        hashMap.put(_menu[1], OneToOne);
        hashMap.put(_menu[2], ZeroToOne);
        hashMap.put(_menu[3], OneToMany);
        hashMap.put(_menu[4], ZeroToMany);
        instances = new Cardinality[]{Root, OneToOne, ZeroToOne, OneToMany, ZeroToMany};
    }
}

