/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.BitMaskImpl;
import com.objectriver.runtime.primitives.ComponentMask;
import com.objectriver.runtime.primitives.ComponentMaskFactory;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.BitSet;

public class ComponentMaskImpl
extends BitMaskImpl
implements ComponentMask {
    private static final int maxSize = 50;

    private ComponentMaskImpl(byte[] bytes) {
        super("", 50);
        this.bytes = new byte[25];
        System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
    }

    private ComponentMaskImpl() {
        super("", 50);
        this.bytes = new byte[25];
    }

    public static ComponentMask valueOf(String hexString) {
        ComponentMaskImpl impl = new ComponentMaskImpl();
        impl.fromString(hexString);
        return impl;
    }

    public static ComponentMask valueOf(BitSet bits) {
        ComponentMaskImpl impl = new ComponentMaskImpl();
        Assert.assertTrue("To many bits!", bits.length() <= 200);
        int nbits = bits.length();
        for (int ii = 1; ii < nbits; ++ii) {
            if (!bits.get(ii)) continue;
            int n = (ii - 1) / 8;
            impl.bytes[n] = (byte)(impl.bytes[n] ^ 1 << (ii - 1) % 8);
        }
        return impl;
    }

    @Override
    public ComponentMask setBit(int index) {
        if ((this.bytes[--index / 8] & 1 << index % 8) != 0) {
            return this;
        }
        byte[] newBytes = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
        newBytes[index / 8] = (byte)(newBytes[index / 8] | 1 << index % 8);
        return new ComponentMaskImpl(newBytes);
    }

    @Override
    public ComponentMask clearBit(int index) {
        if ((this.bytes[--index / 8] & 1 << index % 8) != 0) {
            byte[] newBytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
            newBytes[index / 8] = (byte)(newBytes[index / 8] ^ 1 << index % 8);
            return new ComponentMaskImpl(newBytes);
        }
        return this;
    }

    @Override
    public ComponentMask setBits(BitSet bits) {
        return ComponentMaskFactory.valueOf(bits);
    }

    @Override
    public String getTypeName() {
        return "ComponentMask";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfComponentMask", Timestamp.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return true;
    }

    public static final void main(String[] args) {
        ComponentMask mask = ComponentMaskFactory.valueOf("010004");
        ComponentMask newmask = mask.setBit(9);
        Assert.assertTrue("010004".equals(mask.toString()));
        Assert.assertTrue("010104".equals(newmask.toString()));
        Assert.assertTrue(mask.isSet(1));
        Assert.assertTrue(mask.isSet(19));
        System.out.println(mask.toString() + " " + newmask.toString());
        BitSet bits = new BitSet();
        bits.set(1);
        bits.set(19);
        mask = ComponentMaskFactory.valueOf(bits);
        newmask = mask.setBit(9);
        Assert.assertTrue("010004".equals(mask.toString()));
        Assert.assertTrue("010104".equals(newmask.toString()));
        System.out.println(mask.toString() + " " + newmask.toString());
        mask = newmask.clearBit(9);
        Assert.assertTrue("010004".equals(mask.toString()));
        bits = mask.getBits();
        newmask = mask.setBits(bits);
        Assert.assertTrue("010004".equals(newmask.toString()));
        Assert.assertTrue(newmask.length() == 19);
        bits.clear();
        bits.set(1);
        bits.set(21);
        bits.set(3);
        bits.set(4);
        bits.set(11);
        bits.set(13);
        bits.set(32);
        mask = ComponentMaskFactory.valueOf(bits);
        Assert.assertTrue("0d141080".equals(mask.toString()));
        BitSet bitset2 = mask.getBits();
        ComponentMask mask2 = ComponentMaskFactory.valueOf(bitset2);
        Assert.assertTrue("0d141080".equals(mask2.toString()));
    }
}

