/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.PrimitiveEnumeration;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.abstracts.AbstractEnumeration;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.StringUtility;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;

public final class DeltaEnum
extends AbstractEnumeration
implements PrimitiveEnumeration {
    public static final String typeName = "DeltaEnum";
    private static final String[] _menu = new String[]{"Play Delta Forward", "Play Delta Backward", "Create Delta", "Create Object from Delta"};
    public static final int PlayDeltaForwardInt = 1;
    public static final DeltaEnum PlayDeltaForward = new DeltaEnum(_menu[0], 1, _menu[0]);
    public static final int PlayDeltaBackwardInt = 2;
    public static final DeltaEnum PlayDeltaBackward = new DeltaEnum(_menu[1], 2, _menu[1]);
    public static final int CreateDeltaInt = 3;
    public static final DeltaEnum CreateDelta = new DeltaEnum(_menu[2], 3, _menu[2]);
    public static final int CreateObjectInt = 4;
    public static final DeltaEnum CreateObject = new DeltaEnum(_menu[3], 4, _menu[3]);
    private static final HashMap hashMap = new HashMap(_menu.length);
    private static final DeltaEnum[] instances;

    public static String[] getMenu() {
        return _menu;
    }

    public static String[] getDescriptions() {
        return _menu;
    }

    public static DeltaEnum[] getInstances() {
        return instances;
    }

    private DeltaEnum(String name, int number, String description) {
        super(name, number, description, 30, PrimitiveType.Code);
    }

    @Override
    public PrimitiveEnumeration instanceOf(int enumvalue) {
        return DeltaEnum.valueOf(enumvalue);
    }

    @Override
    public PrimitiveEnumeration instanceOf(String string) {
        return DeltaEnum.valueOf(string);
    }

    public static DeltaEnum valueOf(int enumvalue) {
        switch (enumvalue) {
            case 1: {
                return PlayDeltaForward;
            }
            case 2: {
                return PlayDeltaBackward;
            }
            case 3: {
                return CreateDelta;
            }
            case 4: {
                return CreateObject;
            }
        }
        return null;
    }

    public static DeltaEnum valueOf(String string) {
        Object enumobject = hashMap.get(string);
        if (enumobject == null && StringUtility.isInteger(string)) {
            return DeltaEnum.valueOf(Integer.parseInt(string));
        }
        return (DeltaEnum)enumobject;
    }

    @Override
    public Iterator iterator() {
        return new ArrayIterator(instances);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String getTypeName() {
        return typeName;
    }

    @Override
    protected boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfDeltaEnum", DeltaEnum.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return decend;
    }

    public DeltaEnum valueOfDescription(String description) {
        return DeltaEnum.valueOf(description);
    }

    static {
        hashMap.put(_menu[0], PlayDeltaForward);
        hashMap.put(_menu[1], PlayDeltaBackward);
        hashMap.put(_menu[2], CreateDelta);
        hashMap.put(_menu[3], CreateObject);
        instances = new DeltaEnum[]{PlayDeltaForward, PlayDeltaBackward, CreateDelta, CreateObject};
    }
}

