/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.BitMaskImpl;
import com.objectriver.runtime.primitives.FieldMask;
import com.objectriver.runtime.primitives.FieldMaskFactory;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.BitSet;

public class FieldMaskImpl
extends BitMaskImpl
implements FieldMask {
    private static final int maxSize = 50;

    private FieldMaskImpl(byte[] bytes) {
        super("", 50);
        this.bytes = new byte[25];
        System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
    }

    private FieldMaskImpl() {
        super("", 50);
        this.bytes = new byte[25];
    }

    public static FieldMask valueOf(String hexString) {
        FieldMaskImpl impl = new FieldMaskImpl();
        impl.fromString(hexString);
        return impl;
    }

    public static FieldMask valueOf(BitSet bits) {
        FieldMaskImpl impl = new FieldMaskImpl();
        Assert.assertTrue("To many bits!", bits.length() <= 200);
        int nbits = bits.length();
        for (int ii = 1; ii < nbits; ++ii) {
            if (!bits.get(ii)) continue;
            int n = (ii - 1) / 8;
            impl.bytes[n] = (byte)(impl.bytes[n] ^ 1 << (ii - 1) % 8);
        }
        return impl;
    }

    @Override
    public String getTypeName() {
        return "FieldMask";
    }

    @Override
    public FieldMask setBit(int index) {
        if ((this.bytes[--index / 8] & 1 << index % 8) != 0) {
            return this;
        }
        byte[] newBytes = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
        newBytes[index / 8] = (byte)(newBytes[index / 8] | 1 << index % 8);
        return new FieldMaskImpl(newBytes);
    }

    @Override
    public FieldMask clearBit(int index) {
        if ((this.bytes[--index / 8] & 1 << index % 8) != 0) {
            byte[] newBytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
            newBytes[index / 8] = (byte)(newBytes[index / 8] ^ 1 << index % 8);
            return new FieldMaskImpl(newBytes);
        }
        return this;
    }

    @Override
    public FieldMask setBits(BitSet bits) {
        return FieldMaskFactory.valueOf(bits);
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfFieldMask", Timestamp.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return true;
    }

    public static final void main(String[] args) {
        FieldMask mask = FieldMaskFactory.valueOf("010004");
        FieldMask newmask = mask.setBit(9);
        Assert.assertTrue("010004".equals(mask.toString()));
        Assert.assertTrue("010104".equals(newmask.toString()));
        Assert.assertTrue(mask.isSet(1));
        Assert.assertTrue(mask.isSet(19));
        System.out.println(mask.toString() + " " + newmask.toString());
        BitSet bits = new BitSet();
        bits.set(1);
        bits.set(19);
        mask = FieldMaskFactory.valueOf(bits);
        newmask = mask.setBit(9);
        Assert.assertTrue("010004".equals(mask.toString()));
        Assert.assertTrue("010104".equals(newmask.toString()));
        System.out.println(mask.toString() + " " + newmask.toString());
        mask = newmask.clearBit(9);
        Assert.assertTrue("010004".equals(mask.toString()));
        bits = mask.getBits();
        newmask = mask.setBits(bits);
        Assert.assertTrue("010004".equals(newmask.toString()));
        Assert.assertTrue(newmask.length() == 19);
    }
}

