/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.PrimitiveEnumeration;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.abstracts.AbstractEnumeration;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.StringUtility;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;

public final class HistoryMode
extends AbstractEnumeration
implements PrimitiveEnumeration {
    public static final String typeName = "HistoryMode";
    private static final String[] _menu = new String[]{"NoHistory", "FullHistory", "JustHistoryLog", "JustPublish"};
    public static final String[] _descriptions = new String[]{"No history or transactions", "Full history logging with transactions", "Just history table logging", "Just transaction logging"};
    public static final int NoHistoryInt = 0;
    public static final HistoryMode NoHistory = new HistoryMode(_menu[0], 0, _descriptions[0]);
    public static final int FullHistoryInt = 1;
    public static final HistoryMode FullHistory = new HistoryMode(_menu[1], 1, _descriptions[1]);
    public static final int JustHistoryLogInt = 2;
    public static final HistoryMode JustHistoryLog = new HistoryMode(_menu[2], 2, _descriptions[2]);
    public static final int JustPublishInt = 3;
    public static final HistoryMode JustPublish = new HistoryMode(_menu[3], 3, _descriptions[3]);
    private static final HashMap hashMap = new HashMap(_menu.length);
    private static final HistoryMode[] instances;

    public static String[] getMenu() {
        return _menu;
    }

    public static String[] getDescriptions() {
        return _descriptions;
    }

    public static HistoryMode[] getInstances() {
        return instances;
    }

    private HistoryMode(String name, int number, String description) {
        super(name, number, description, 2, PrimitiveType.Enumeration);
    }

    @Override
    public PrimitiveEnumeration instanceOf(int enumvalue) {
        return HistoryMode.valueOf(enumvalue);
    }

    @Override
    public PrimitiveEnumeration instanceOf(String string) {
        return HistoryMode.valueOf(string);
    }

    public static HistoryMode valueOf(int enumvalue) {
        switch (enumvalue) {
            case 0: {
                return NoHistory;
            }
            case 1: {
                return FullHistory;
            }
            case 2: {
                return JustHistoryLog;
            }
            case 3: {
                return JustPublish;
            }
        }
        return null;
    }

    public static HistoryMode valueOf(String string) {
        Object enumobject = hashMap.get(string);
        if (enumobject == null && StringUtility.isInteger(string)) {
            return HistoryMode.valueOf(Integer.parseInt(string));
        }
        return (HistoryMode)enumobject;
    }

    @Override
    public Iterator iterator() {
        return new ArrayIterator(instances);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String getTypeName() {
        return typeName;
    }

    @Override
    protected boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfHistoryMode", HistoryMode.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return decend;
    }

    public HistoryMode valueOfDescription(String description) {
        for (int ii = 0; ii < _descriptions.length; ++ii) {
            if (description != _descriptions[ii]) continue;
            return instances[ii];
        }
        return null;
    }

    static {
        hashMap.put(_menu[0], NoHistory);
        hashMap.put("None", NoHistory);
        hashMap.put(_menu[1], FullHistory);
        hashMap.put("Full", FullHistory);
        hashMap.put(_menu[2], JustHistoryLog);
        hashMap.put("LogOnly", JustHistoryLog);
        hashMap.put("JustHistory", JustHistoryLog);
        hashMap.put(_menu[3], JustPublish);
        hashMap.put("QueueOnly", JustPublish);
        hashMap.put("JustEvents", JustPublish);
        hashMap.put("JustTransactionQueue", JustPublish);
        instances = new HistoryMode[]{NoHistory, FullHistory, JustHistoryLog, JustPublish};
    }
}

