/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.PrimitiveEnumeration;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.abstracts.AbstractEnumeration;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.StringUtility;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;

public final class HistoryOperationType
extends AbstractEnumeration
implements PrimitiveEnumeration {
    public static final String typeName = "HistoryOperationType";
    private static final String[] _menu = new String[]{"Insert", "Update", "Delete", "Unchanged"};
    public static final String[] _descriptions = new String[]{_menu[0], _menu[1], _menu[2], _menu[3]};
    public static final int InsertInt = 1;
    public static final HistoryOperationType Insert = new HistoryOperationType(_menu[0], 1, _descriptions[0]);
    public static final int UpdateInt = 2;
    public static final HistoryOperationType Update = new HistoryOperationType(_menu[1], 2, _descriptions[1]);
    public static final int DeleteInt = 3;
    public static final HistoryOperationType Delete = new HistoryOperationType(_menu[2], 3, _descriptions[2]);
    public static final int UnchangedInt = 4;
    public static final HistoryOperationType Unchanged = new HistoryOperationType(_menu[3], 4, _descriptions[3]);
    private static final HashMap hashMap = new HashMap(_menu.length);
    private static final HistoryOperationType[] instances;

    public static String[] getMenu() {
        return _menu;
    }

    public static String[] getDescriptions() {
        return _descriptions;
    }

    public static HistoryOperationType[] getInstances() {
        return instances;
    }

    private HistoryOperationType(String name, int number, String description) {
        super(name, number, description, 2, PrimitiveType.Enumeration);
    }

    @Override
    public PrimitiveEnumeration instanceOf(int enumvalue) {
        return HistoryOperationType.valueOf(enumvalue);
    }

    @Override
    public PrimitiveEnumeration instanceOf(String string) {
        return HistoryOperationType.valueOf(string);
    }

    public static HistoryOperationType valueOf(int enumvalue) {
        switch (enumvalue) {
            case 1: {
                return Insert;
            }
            case 2: {
                return Update;
            }
            case 3: {
                return Delete;
            }
            case 4: {
                return Unchanged;
            }
        }
        return null;
    }

    public static HistoryOperationType valueOf(String string) {
        Object enumobject = hashMap.get(string);
        if (enumobject == null && StringUtility.isInteger(string)) {
            return HistoryOperationType.valueOf(Integer.parseInt(string));
        }
        return (HistoryOperationType)enumobject;
    }

    @Override
    public Iterator iterator() {
        return new ArrayIterator(instances);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String getTypeName() {
        return typeName;
    }

    @Override
    protected boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfHistoryOperationType", HistoryOperationType.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return decend;
    }

    public HistoryOperationType valueOfDescription(String description) {
        for (int ii = 0; ii < _descriptions.length; ++ii) {
            if (description != _descriptions[ii]) continue;
            return instances[ii];
        }
        return null;
    }

    static {
        hashMap.put(_menu[0], Insert);
        hashMap.put(_menu[1], Update);
        hashMap.put(_menu[2], Delete);
        hashMap.put(_menu[3], Unchanged);
        instances = new HistoryOperationType[]{Insert, Update, Delete, Unchanged};
    }
}

