/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.PrimitiveEnumeration;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.abstracts.AbstractEnumeration;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.StringUtility;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;

public final class NativeType
extends AbstractEnumeration
implements PrimitiveEnumeration {
    public static final String typeName = "NativeType";
    private static final String[] _menu = new String[]{"Boolean", "Character", "Long", "Integer", "Short", "Byte", "Float", "Double", "String", "bytes[]", "Timestamp", "Date", "BigDecimal"};
    public static final int BooleanInt = 1;
    public static final NativeType Boolean = new NativeType(_menu[0], 1, _menu[0]);
    public static final int CharacterInt = 2;
    public static final NativeType Character = new NativeType(_menu[1], 2, _menu[1]);
    public static final int LongInt = 3;
    public static final NativeType Long = new NativeType(_menu[2], 3, _menu[2]);
    public static final int IntegerInt = 4;
    public static final NativeType Integer = new NativeType(_menu[3], 4, _menu[3]);
    public static final int ShortInt = 5;
    public static final NativeType Short = new NativeType(_menu[4], 5, _menu[4]);
    public static final int ByteInt = 6;
    public static final NativeType Byte = new NativeType(_menu[5], 6, _menu[5]);
    public static final int FloatInt = 7;
    public static final NativeType Float = new NativeType(_menu[6], 7, _menu[6]);
    public static final int DoubleInt = 8;
    public static final NativeType Double = new NativeType(_menu[7], 8, _menu[7]);
    public static final int StringInt = 9;
    public static final NativeType String = new NativeType(_menu[8], 9, _menu[8]);
    public static final int VarBinaryInt = 13;
    public static final NativeType VarBinary = new NativeType(_menu[9], 13, _menu[9]);
    public static final int TimestampInt = 10;
    public static final NativeType Timestamp = new NativeType(_menu[10], 10, _menu[10]);
    public static final int DateInt = 12;
    public static final NativeType Date = new NativeType(_menu[11], 12, _menu[11]);
    public static final int BigDecimalInt = 11;
    public static final NativeType BigDecimal = new NativeType(_menu[12], 11, _menu[12]);
    private static final HashMap hashMap = new HashMap(_menu.length);
    private static final NativeType[] instances;

    public static String[] getMenu() {
        return _menu;
    }

    public static String[] getDescriptions() {
        return _menu;
    }

    public static NativeType[] getInstances() {
        return instances;
    }

    private NativeType(String name, int number, String description) {
        super(name, number, description, 2, PrimitiveType.Enumeration);
    }

    @Override
    public PrimitiveEnumeration instanceOf(int enumvalue) {
        return NativeType.valueOf(enumvalue);
    }

    @Override
    public PrimitiveEnumeration instanceOf(String string) {
        return NativeType.valueOf(string);
    }

    public static NativeType valueOf(int enumvalue) {
        switch (enumvalue) {
            case 1: {
                return Boolean;
            }
            case 2: {
                return Character;
            }
            case 3: {
                return Long;
            }
            case 4: {
                return Integer;
            }
            case 5: {
                return Short;
            }
            case 6: {
                return Byte;
            }
            case 7: {
                return Float;
            }
            case 8: {
                return Double;
            }
            case 9: {
                return String;
            }
            case 13: {
                return VarBinary;
            }
            case 10: {
                return Timestamp;
            }
            case 12: {
                return Date;
            }
            case 11: {
                return BigDecimal;
            }
        }
        return null;
    }

    public static NativeType valueOf(String string) {
        Object enumobject = hashMap.get(string);
        if (enumobject == null && StringUtility.isInteger(string)) {
            return NativeType.valueOf(java.lang.Integer.parseInt(string));
        }
        return (NativeType)enumobject;
    }

    @Override
    public Iterator iterator() {
        return new ArrayIterator(instances);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String getTypeName() {
        return typeName;
    }

    @Override
    protected boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfNativeType", NativeType.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return decend;
    }

    public NativeType valueOfDescription(String description) {
        return NativeType.valueOf(description);
    }

    static {
        hashMap.put(_menu[0], Boolean);
        hashMap.put("bool", Boolean);
        hashMap.put(_menu[1], Character);
        hashMap.put("char", Character);
        hashMap.put(_menu[2], Long);
        hashMap.put("long", Long);
        hashMap.put("Number", Long);
        hashMap.put(_menu[3], Integer);
        hashMap.put("int", Integer);
        hashMap.put(_menu[4], Short);
        hashMap.put("short", Short);
        hashMap.put(_menu[5], Byte);
        hashMap.put("byte[]", Byte);
        hashMap.put(_menu[6], Float);
        hashMap.put("float", Float);
        hashMap.put(_menu[7], Double);
        hashMap.put("double", Double);
        hashMap.put(_menu[8], String);
        hashMap.put("VarChar", String);
        hashMap.put("FixedChar", String);
        hashMap.put("Clob", String);
        hashMap.put(_menu[9], VarBinary);
        hashMap.put(_menu[10], Timestamp);
        hashMap.put(_menu[11], Date);
        hashMap.put(_menu[12], BigDecimal);
        hashMap.put("Decimal", BigDecimal);
        instances = new NativeType[]{Boolean, Character, Long, Integer, Short, Byte, Float, Double, String, VarBinary, Timestamp, Date, BigDecimal};
    }
}

