/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.PrimitiveEnumeration;
import com.objectriver.runtime.primitives.abstracts.AbstractEnumeration;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.StringUtility;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;

public final class PrimitiveType
extends AbstractEnumeration
implements PrimitiveEnumeration {
    public static final String typeName = "PrimitiveType";
    private static final String[] _menu = new String[]{"Boolean", "Character", "Number", "Decimal", "VarChar", "FixedChar", "Clob", "Enumeration", "Code", "Timestamp", "Date", "Struct", "Persistent", "Sequence", "IdentitySequence", "VarBinary", "Blob", "Bean"};
    public static final int BooleanInt = 1;
    public static final PrimitiveType Boolean = new PrimitiveType(_menu[0], 1, _menu[0]);
    public static final int CharacterInt = 2;
    public static final PrimitiveType Character = new PrimitiveType(_menu[1], 2, _menu[1]);
    public static final int NumberInt = 3;
    public static final PrimitiveType Number = new PrimitiveType(_menu[2], 3, _menu[2]);
    public static final int DecimalInt = 4;
    public static final PrimitiveType Decimal = new PrimitiveType(_menu[3], 4, _menu[3]);
    public static final int VarCharInt = 5;
    public static final PrimitiveType VarChar = new PrimitiveType(_menu[4], 5, _menu[4]);
    public static final int FixedCharInt = 6;
    public static final PrimitiveType FixedChar = new PrimitiveType(_menu[5], 6, _menu[5]);
    public static final int ClobInt = 7;
    public static final PrimitiveType Clob = new PrimitiveType(_menu[6], 7, _menu[6]);
    public static final int EnumerationInt = 8;
    public static final PrimitiveType Enumeration = new PrimitiveType(_menu[7], 8, _menu[7]);
    public static final int CodeInt = 10;
    public static final PrimitiveType Code = new PrimitiveType(_menu[8], 10, _menu[8]);
    public static final int TimestampInt = 9;
    public static final PrimitiveType Timestamp = new PrimitiveType(_menu[9], 9, _menu[9]);
    public static final int DateInt = 14;
    public static final PrimitiveType Date = new PrimitiveType(_menu[10], 14, _menu[10]);
    public static final int StructInt = 11;
    public static final PrimitiveType Struct = new PrimitiveType(_menu[11], 11, _menu[11]);
    public static final int PersistentInt = 12;
    public static final PrimitiveType Persistent = new PrimitiveType(_menu[12], 12, _menu[12]);
    public static final int SequenceInt = 13;
    public static final PrimitiveType Sequence = new PrimitiveType(_menu[13], 13, _menu[13]);
    public static final int IdentitySequenceInt = 15;
    public static final PrimitiveType IdentitySequence = new PrimitiveType(_menu[14], 15, _menu[14]);
    public static final int VarBinaryInt = 16;
    public static final PrimitiveType VarBinary = new PrimitiveType(_menu[15], 16, _menu[15]);
    public static final int BlobInt = 18;
    public static final PrimitiveType Blob = new PrimitiveType(_menu[16], 18, _menu[16]);
    public static final int BeanInt = 20;
    public static final PrimitiveType Bean = new PrimitiveType(_menu[17], 20, _menu[17]);
    private static final HashMap hashMap = new HashMap(_menu.length);
    private static final PrimitiveType[] instances;

    public static String[] getMenu() {
        return _menu;
    }

    public static String[] getDescriptions() {
        return _menu;
    }

    public static PrimitiveType[] getInstances() {
        return instances;
    }

    private PrimitiveType(String name, int number, String description) {
        super(name, number, description, 2, Enumeration);
    }

    @Override
    public PrimitiveEnumeration instanceOf(int enumvalue) {
        return PrimitiveType.valueOf(enumvalue);
    }

    @Override
    public PrimitiveEnumeration instanceOf(String string) {
        return PrimitiveType.valueOf(string);
    }

    public static PrimitiveType valueOf(int enumvalue) {
        switch (enumvalue) {
            case 1: {
                return Boolean;
            }
            case 2: {
                return Character;
            }
            case 3: {
                return Number;
            }
            case 4: {
                return Decimal;
            }
            case 5: {
                return VarChar;
            }
            case 6: {
                return FixedChar;
            }
            case 7: {
                return Clob;
            }
            case 8: {
                return Enumeration;
            }
            case 10: {
                return Code;
            }
            case 9: {
                return Timestamp;
            }
            case 14: {
                return Date;
            }
            case 11: {
                return Struct;
            }
            case 12: {
                return Persistent;
            }
            case 13: {
                return Sequence;
            }
            case 15: {
                return IdentitySequence;
            }
            case 16: {
                return VarBinary;
            }
            case 18: {
                return Blob;
            }
            case 20: {
                return Bean;
            }
        }
        return null;
    }

    public static PrimitiveType valueOf(String string) {
        Object enumobject = hashMap.get(string);
        if (enumobject == null && StringUtility.isInteger(string)) {
            return PrimitiveType.valueOf(Integer.parseInt(string));
        }
        return (PrimitiveType)enumobject;
    }

    @Override
    public Iterator iterator() {
        return new ArrayIterator(instances);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String getTypeName() {
        return typeName;
    }

    @Override
    protected boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfPrimitiveType", PrimitiveType.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return decend;
    }

    public PrimitiveType valueOfDescription(String description) {
        return PrimitiveType.valueOf(description);
    }

    static {
        hashMap.put(_menu[0], Boolean);
        hashMap.put(_menu[1], Character);
        hashMap.put(_menu[2], Number);
        hashMap.put(_menu[3], Decimal);
        hashMap.put(_menu[4], VarChar);
        hashMap.put(_menu[5], FixedChar);
        hashMap.put(_menu[6], Clob);
        hashMap.put(_menu[7], Enumeration);
        hashMap.put(_menu[8], Code);
        hashMap.put(_menu[9], Timestamp);
        hashMap.put(_menu[10], Date);
        hashMap.put(_menu[11], Struct);
        hashMap.put(_menu[12], Persistent);
        hashMap.put(_menu[13], Sequence);
        hashMap.put(_menu[14], IdentitySequence);
        hashMap.put(_menu[15], VarBinary);
        hashMap.put(_menu[16], Blob);
        hashMap.put(_menu[17], Bean);
        instances = new PrimitiveType[]{Boolean, Character, Number, Decimal, VarChar, FixedChar, Clob, Enumeration, Code, Timestamp, Date, Struct, Persistent, Sequence, IdentitySequence, VarBinary, Blob, Bean};
    }
}

