/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.VarBinary;
import com.objectriver.runtime.primitives.VarBinaryImpl;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;

public class RawImpl
extends VarBinaryImpl {
    public RawImpl(String hexData) {
        super(RawImpl.hexToRaw(hexData));
    }

    public RawImpl(byte[] bytes) {
        super(bytes);
    }

    @Override
    public String toString() {
        return RawImpl.rawToHex(this.bytes);
    }

    @Override
    public String getTypeName() {
        return "Raw";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            if (decend) {
                Method method = visitor.getClass().getMethod("visitOfRaw", VarBinary.class);
                method.invoke((Object)visitor, this);
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            System.err.println("Visitor class access error. Vistor " + visitor.getClass().toString() + " may be nested or non-public!");
            Assert.fail("IllegalAccessException: " + e.getMessage());
        }
        catch (Exception e) {
            String message = "Internal Error: ";
            if (e != null) {
                message = message + e.getMessage();
            }
            Assert.fail(message);
        }
        return decend;
    }

    protected static boolean isHex(String data) {
        boolean isHex = true;
        if (data != null) {
            char[] chars;
            for (char c : chars = data.toCharArray()) {
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
                isHex = false;
                break;
            }
        }
        return isHex;
    }

    public static byte[] hexToRaw(String hexData) {
        byte[] bytes = null;
        if (RawImpl.isHex(hexData)) {
            if (hexData.length() % 2 == 0) {
                if (hexData != null) {
                    bytes = new byte[hexData.length() / 2];
                    for (int ii = 0; ii < hexData.length(); ii += 2) {
                        String strByte = hexData.substring(ii, ii + 2);
                        int intByte = Integer.parseInt(strByte, 16);
                        bytes[ii / 2] = (byte)intByte;
                    }
                }
            } else {
                Assert.fail("Raw must be created by using a hex string with even length.");
            }
        } else {
            Assert.fail("Raw must be created by using a hex string.");
        }
        return bytes;
    }

    public static String rawToHex(byte[] bytes) {
        String hexData = null;
        if (bytes != null) {
            StringBuilder hexStringBuilder = new StringBuilder();
            for (byte b : bytes) {
                int i = b & 0xFF;
                String hexStr = Integer.toHexString(i);
                if (hexStr.length() == 1) {
                    hexStr = "0" + hexStr;
                }
                hexStringBuilder.append(hexStr);
            }
            hexData = hexStringBuilder.toString();
        }
        return hexData;
    }

    public static void main(String[] args) {
        String data = "001199aaff";
        RawImpl raw = new RawImpl(data);
        System.out.println("data: " + data + ", raw string: " + raw);
    }
}

