/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.Struct;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;

public class StructFactory {
    public static Struct valueOf(String structString) {
        if (structString == null) {
            return null;
        }
        Assert.assertTrue("Invalid Struct format:" + structString, structString.endsWith(".Struct"));
        StringBuffer className = new StringBuffer(64).append("primitives.").append(structString.substring(0, structString.indexOf(40))).append("Factory");
        try {
            Class<?> structClassFactory = Class.forName(className.toString());
            Method method = structClassFactory.getDeclaredMethod("valueOf", String.class);
            Struct struct = (Struct)method.invoke(null, structString);
            return struct;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Assert.fail("Struct Class " + className + " Not Found?");
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            Assert.fail("Internal Error: " + className + "(String) Constructor not found?");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail("Internal Error: " + className + "(String) Constructor?");
        }
        return null;
    }

    public static void main(String[] args) {
        String str = "AggType(1234,\"fred ralph\").Struct";
        Struct struct = StructFactory.valueOf(str);
        System.out.println(struct.toString());
    }
}

