/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.PrimitiveTimestamp;
import com.objectriver.runtime.primitives.TimestampImmutable;
import com.objectriver.runtime.util.StringUtility;
import java.sql.Date;
import java.sql.Timestamp;

public class TimestampFactory {
    public static Timestamp valueOf(long value) {
        return new TimestampImmutable(value);
    }

    public static Timestamp valueOf(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new TimestampImmutable(timestamp);
    }

    public static Timestamp valueOf(String value) {
        if (value == null) {
            return null;
        }
        if (StringUtility.isInteger(value)) {
            return TimestampFactory.valueOf(Long.parseLong(value));
        }
        if (value.endsWith("Z")) {
            value = value.substring(0, value.length() - 1);
        }
        return TimestampFactory.valueOf(Timestamp.valueOf(value.replaceFirst("T", " ")));
    }

    public static Timestamp valueOf(Date date) {
        if (date == null) {
            return null;
        }
        return new TimestampImmutable(date);
    }

    public static Timestamp timestampValue(Object object) {
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof PrimitiveTimestamp) {
            return ((PrimitiveTimestamp)object).timestampValue();
        }
        return null;
    }
}

