/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives;

import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.VarBinary;
import com.objectriver.runtime.primitives.abstracts.AbstractPrimitiveVarBinary;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;

public class VarBinaryImpl
extends AbstractPrimitiveVarBinary
implements VarBinary {
    protected byte[] bytes;

    public VarBinaryImpl(byte[] bytes) {
        super(bytes, bytes.length, PrimitiveType.VarBinary);
        this.bytes = bytes;
    }

    protected VarBinaryImpl(String value) {
        super(null, value.length(), PrimitiveType.VarBinary);
        Assert.fail();
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int ii = 0; ii < this.bytes.length; ++ii) {
            buff.append(Integer.toHexString(this.bytes[ii]));
        }
        return buff.toString();
    }

    @Override
    public String getTypeName() {
        return "VarBinary";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            if (decend) {
                Method method = visitor.getClass().getMethod("visitOfVarBinary", VarBinary.class);
                method.invoke((Object)visitor, this);
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            System.err.println("Visitor class access error. Vistor " + visitor.getClass().toString() + " may be nested or non-public!");
            Assert.fail("IllegalAccessException: " + e.getMessage());
        }
        catch (Exception e) {
            String message = "Internal Error: ";
            if (e != null) {
                message = message + e.getMessage();
            }
            Assert.fail(message);
        }
        return decend;
    }
}

