/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives.abstracts;

import com.objectriver.runtime.primitives.PrimitiveEnumeration;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.abstracts.AbstractPrimitive;

public abstract class AbstractEnumeration
extends AbstractPrimitive
implements PrimitiveEnumeration {
    private final String name;
    private final long number;
    private final String value;
    private final String description;
    private final int maxSize;

    protected AbstractEnumeration(String name, int number, String description, int maxSize, PrimitiveType type) {
        super(type);
        this.name = name;
        this.value = null;
        this.number = number;
        this.maxSize = maxSize;
        this.description = description == null || description == "" ? name : description;
    }

    protected AbstractEnumeration(String name, String value, int number, String description, int maxSize, PrimitiveType type) {
        super(type);
        this.name = name;
        this.value = value;
        this.number = number;
        this.maxSize = maxSize;
        this.description = description == null || description == "" ? name : description;
    }

    public int compareTo(Object o) {
        AbstractEnumeration ao = (AbstractEnumeration)o;
        if (this.number == ao.number) {
            return 0;
        }
        if (this.number < ao.number) {
            return -1;
        }
        return 1;
    }

    @Override
    public short shortValue() {
        return (short)this.number;
    }

    @Override
    public int intValue() {
        return (int)this.number;
    }

    @Override
    public long longValue() {
        return this.number;
    }

    @Override
    public String toString() {
        if (this.getPrimitiveType() == PrimitiveType.Code) {
            return this.name;
        }
        return new Long(this.number).toString();
    }

    @Override
    public String getName() {
        if (this.value != null) {
            return this.value;
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }
}

