/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives.abstracts;

import com.objectriver.runtime.primitives.PrimitiveBoolean;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.StringConst;
import com.objectriver.runtime.primitives.abstracts.AbstractPrimitive;

public abstract class AbstractPrimitiveBoolean
extends AbstractPrimitive
implements PrimitiveBoolean {
    private boolean bool;

    public AbstractPrimitiveBoolean(boolean bool) {
        super(PrimitiveType.Boolean);
        this.bool = bool;
    }

    public int compareTo(Object o) {
        AbstractPrimitiveBoolean ao = (AbstractPrimitiveBoolean)o;
        if (this.bool == ao.bool) {
            return 0;
        }
        if (this.bool) {
            return 1;
        }
        return -1;
    }

    @Override
    public String toString() {
        if (this.bool) {
            return StringConst.True;
        }
        return StringConst.False;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractPrimitiveBoolean)) {
            return false;
        }
        AbstractPrimitiveBoolean as = (AbstractPrimitiveBoolean)object;
        return as.bool == this.bool;
    }

    public int hashCode() {
        if (this.bool) {
            return 630;
        }
        return 260;
    }

    @Override
    public boolean booleanValue() {
        return this.bool;
    }

    @Override
    public String getPersistentString() {
        return this.bool ? "T" : "F";
    }

    public static final void main(String[] args) {
        Boolean one = new Boolean(true);
        Boolean two = new Boolean(true);
        if (one == two) {
            System.out.println("The VM is caching Booleans!");
        } else {
            System.out.println("The VM is NOT caching Booleans!");
        }
        String three = one.toString();
        String four = two.toString();
        if (three == four) {
            System.out.println("The VM is caching Boolean Strings!");
        } else {
            System.out.println("The VM is NOT caching Boolean Strings!");
        }
    }
}

