/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives.abstracts;

import com.objectriver.runtime.primitives.DateFactory;
import com.objectriver.runtime.primitives.PrimitiveDate;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.abstracts.AbstractPrimitive;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.sql.Date;

public abstract class AbstractPrimitiveDate
extends AbstractPrimitive
implements PrimitiveDate {
    private Date dateVal;

    public AbstractPrimitiveDate(long time) {
        super(PrimitiveType.Date);
        this.dateVal = DateFactory.valueOf(time);
    }

    @Override
    public long getTime() {
        return this.dateVal.getTime();
    }

    @Override
    public long longValue() {
        return this.dateVal.getTime();
    }

    @Override
    public Date dateValue() {
        return this.dateVal;
    }

    @Override
    protected boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfDate", Date.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o instanceof AbstractPrimitiveDate) {
            AbstractPrimitiveDate that = (AbstractPrimitiveDate)o;
            if (this.equals(that)) {
                return 0;
            }
            return this.dateVal.compareTo(that.dateVal);
        }
        throw new UnsupportedOperationException("invalid comparison");
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractPrimitiveDate) {
            AbstractPrimitiveDate that = (AbstractPrimitiveDate)o;
            return this.dateVal.equals(that.dateVal);
        }
        return false;
    }

    public int hashCode() {
        return this.dateVal.hashCode();
    }

    @Override
    public String toString() {
        return this.dateVal.toString();
    }
}

