/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives.abstracts;

import com.objectriver.runtime.primitives.Primitive;
import com.objectriver.runtime.primitives.PrimitiveDecimal;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.things.Visitor;
import java.math.BigDecimal;

public abstract class AbstractPrimitiveDecimal
extends Number
implements PrimitiveDecimal,
Primitive {
    protected BigDecimal number;
    private int precision;
    private int scale;
    private static final int ROUND = 4;
    private static final int MAXPRECISION = 38;

    protected AbstractPrimitiveDecimal(double value, int precision, int scale) {
        BigDecimal d;
        if (scale >= 0) {
            d = new BigDecimal(value);
            if (d.scale() != scale) {
                d = d.setScale(scale, 4);
            }
        } else {
            double scalefactor = Math.pow(10.0, scale);
            d = new BigDecimal((double)Math.round(value * scalefactor) / scalefactor);
            if (d.scale() != 0) {
                d = d.setScale(0, 4);
            }
        }
        this.number = d;
        this.precision = precision;
        this.scale = scale;
    }

    protected AbstractPrimitiveDecimal(BigDecimal d) {
        this.precision = 38;
        this.scale = d.scale();
        this.number = d;
    }

    protected AbstractPrimitiveDecimal(BigDecimal d, int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
        if (d.scale() == scale) {
            this.number = d;
        } else if (scale >= 0) {
            this.number = d.setScale(scale, 4);
        } else {
            this.number = d;
            if ((d = d.movePointLeft(-scale)).scale() != 0) {
                d = d.setScale(0, 4);
                this.number = d.movePointRight(-scale);
            }
        }
    }

    protected AbstractPrimitiveDecimal(double d) {
        this.precision = 15;
        this.number = new BigDecimal(d);
        this.scale = this.number.scale();
    }

    protected AbstractPrimitiveDecimal(float d) {
        this.precision = 7;
        this.number = new BigDecimal(d);
        this.scale = this.number.scale();
    }

    public int compareTo(Object o) {
        AbstractPrimitiveDecimal ao = (AbstractPrimitiveDecimal)o;
        return ao.number.compareTo(this.number);
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        return PrimitiveType.Decimal;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public byte byteValue() {
        return (byte)this.number.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.number.intValue();
    }

    @Override
    public int intValue() {
        return this.number.intValue();
    }

    @Override
    public long longValue() {
        return this.number.longValue();
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    @Override
    public BigDecimal decimalValue() {
        return this.number;
    }

    @Override
    public String toString() {
        return this.number.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PrimitiveDecimal)) {
            return false;
        }
        AbstractPrimitiveDecimal decimal = (AbstractPrimitiveDecimal)object;
        return this.number.equals(decimal.number);
    }

    public int hashCode() {
        long hashable = this.number.hashCode();
        return (int)(hashable ^ hashable >>> 32);
    }

    protected abstract boolean acceptVisit(Visitor var1, boolean var2);

    @Override
    public void visit(Visitor visitor) {
        this.acceptVisit(visitor, true);
    }
}

