/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives.abstracts;

import com.objectriver.runtime.pm.PersistenceManagerPlus;
import com.objectriver.runtime.primitives.PrimitiveSequence;
import com.objectriver.runtime.primitives.abstracts.AbstractPrimitiveNumber;
import com.objectriver.runtime.util.RandomSingleton;
import javax.jdo.PersistenceManager;

public abstract class AbstractPrimitiveSequence
extends AbstractPrimitiveNumber
implements PrimitiveSequence {
    protected String nan = null;

    public AbstractPrimitiveSequence(long num, int precision) {
        super(num, precision);
    }

    public AbstractPrimitiveSequence(long num) {
        super(num, 19);
    }

    public AbstractPrimitiveSequence(int num) {
        super(num, 19);
    }

    public AbstractPrimitiveSequence() {
        super(RandomSingleton.getInstance().nextLong(10, true), 19);
        this.nan = "NAN";
    }

    public AbstractPrimitiveSequence(String num) {
        super(num.startsWith("NAN") ? Long.parseLong(num.substring(3)) : Long.parseLong(num), 19);
        if (num.startsWith("NAN")) {
            this.nan = "NAN";
        }
    }

    @Override
    public boolean isNan() {
        return this.nan != null;
    }

    @Override
    public int compareTo(Object o) {
        AbstractPrimitiveSequence ao = (AbstractPrimitiveSequence)o;
        if (this.nan != null) {
            return this.nan.compareTo(ao.nan);
        }
        return super.compareTo(o);
    }

    @Override
    public String toString() {
        if (this.nan != null) {
            StringBuffer tmp = new StringBuffer(32).append('\"').append(this.nan).append(super.toString()).append('\"');
            return tmp.toString();
        }
        return super.toString();
    }

    @Override
    public void setSequence(PersistenceManager pm) {
        if (this.isNan()) {
            long seq;
            PersistenceManagerPlus pmplus = (PersistenceManagerPlus)pm;
            this.number = seq = pmplus.getSequence(this.getSequenceName());
            this.nan = null;
        }
    }

    @Override
    public String getSequenceName() {
        return this.getTypeName();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractPrimitiveSequence)) {
            return false;
        }
        AbstractPrimitiveSequence as = (AbstractPrimitiveSequence)object;
        if (as == null) {
            return false;
        }
        if (this.nan != null) {
            return this.toString().equals(as.toString());
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }
}

