/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives.abstracts;

import com.objectriver.runtime.primitives.PrimitiveString;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.abstracts.AbstractPrimitive;
import com.objectriver.runtime.util.StringUtility;

public abstract class AbstractPrimitiveString
extends AbstractPrimitive
implements PrimitiveString {
    protected String string;
    protected int maxSize;

    public AbstractPrimitiveString(String string, int maxSize, PrimitiveType type) {
        super(type);
        int len;
        this.string = type == PrimitiveType.FixedChar ? ((len = string.length()) < maxSize ? StringUtility.pad(string, ' ', maxSize) : (len > maxSize ? StringUtility.truncate(string, maxSize) : string)) : string;
        this.maxSize = maxSize;
    }

    public int compareTo(Object o) {
        AbstractPrimitiveString ao = (AbstractPrimitiveString)o;
        return this.string.compareTo(ao.string);
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public String toString() {
        return this.string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractPrimitiveString)) {
            return false;
        }
        AbstractPrimitiveString as = (AbstractPrimitiveString)object;
        return as.string.equals(this.string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

