/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives.abstracts;

import com.objectriver.runtime.primitives.PrimitiveTimestamp;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.TimestampFactory;
import com.objectriver.runtime.primitives.abstracts.AbstractPrimitive;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.asserts.Assert;
import java.lang.reflect.Method;
import java.sql.Timestamp;

public abstract class AbstractPrimitiveTimestamp
extends AbstractPrimitive
implements PrimitiveTimestamp {
    private Timestamp timestamp;

    public AbstractPrimitiveTimestamp(long time) {
        super(PrimitiveType.Timestamp);
        this.timestamp = TimestampFactory.valueOf(time);
    }

    @Override
    public long getTime() {
        return this.timestamp.getTime();
    }

    @Override
    protected boolean acceptVisit(Visitor visitor, boolean decend) {
        Assert.assertTrue(visitor.isTypeVisitor());
        try {
            Method method = visitor.getClass().getMethod("visitOfTimestamp", Timestamp.class);
            method.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            Assert.fail("Internal Error");
        }
        return true;
    }

    @Override
    public Timestamp timestampValue() {
        return this.timestamp;
    }

    public int compareTo(Object o) {
        if (o instanceof AbstractPrimitiveTimestamp) {
            AbstractPrimitiveTimestamp that = (AbstractPrimitiveTimestamp)o;
            return this.timestamp.compareTo(that.timestamp);
        }
        throw new UnsupportedOperationException("invalid comparison");
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractPrimitiveTimestamp) {
            AbstractPrimitiveTimestamp that = (AbstractPrimitiveTimestamp)o;
            return this.timestamp.equals(that.timestamp);
        }
        return false;
    }

    public int hashCode() {
        return this.timestamp.hashCode();
    }

    @Override
    public String toString() {
        return this.timestamp.toString();
    }
}

