/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.primitives.abstracts;

import com.objectriver.runtime.primitives.PrimitiveString;
import com.objectriver.runtime.primitives.PrimitiveType;
import com.objectriver.runtime.primitives.abstracts.AbstractPrimitive;
import com.objectriver.runtime.util.asserts.Assert;

public abstract class AbstractPrimitiveVarBinary
extends AbstractPrimitive
implements PrimitiveString {
    protected byte[] bytes;
    protected int maxSize;

    public AbstractPrimitiveVarBinary(byte[] bytes, int maxSize, PrimitiveType type) {
        super(type);
        this.bytes = bytes;
        this.maxSize = maxSize;
    }

    public int compareTo(Object o) {
        if (!(o instanceof AbstractPrimitiveVarBinary)) {
            Assert.fail("not instance of VarBinary");
        }
        AbstractPrimitiveVarBinary ao = (AbstractPrimitiveVarBinary)o;
        return this.bytesCompare(this.bytes, ao.getBytes());
    }

    public int get_size() {
        return this.bytes.length;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int ii = 0; ii < this.bytes.length; ++ii) {
            buff.append(this.byteToHex(this.bytes[ii]));
        }
        return buff.toString();
    }

    private String byteToHex(byte b) {
        int i = b & 0xFF;
        String tmp = Integer.toHexString(i);
        if (tmp.length() == 1) {
            return '0' + tmp;
        }
        return tmp;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractPrimitiveVarBinary)) {
            return false;
        }
        AbstractPrimitiveVarBinary as = (AbstractPrimitiveVarBinary)object;
        return this.bytesCompare(this.bytes, as.getBytes()) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private int bytesCompare(byte[] bytes, byte[] that) {
        if (bytes.length != that.length) {
            return -1;
        }
        for (int ii = 0; ii < bytes.length; ++ii) {
            if (that[ii] == bytes[ii]) continue;
            return bytes[ii] < that[ii] ? -1 : 1;
        }
        return 0;
    }
}

