/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.test;

import com.objectriver.runtime.primitives.PrimitiveEnumeration;
import com.objectriver.runtime.primitives.TimestampFactory;
import com.objectriver.runtime.util.RandomSingleton;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Random;

public class RandomData {
    private Random rand = new Random(RandomSingleton.getInstance().nextLong());
    private long baseTime = System.currentTimeMillis();
    private static final int NULLRANGE = 2;
    private int nullRange = 2;
    private static final int[] exp10 = new int[]{1, 10, 100};

    private boolean getNull(boolean notnull) {
        return notnull ? false : this.nextInt(this.nullRange) == 1;
    }

    private long getLongRange(int places) {
        if (places > 18) {
            places = 18;
        }
        if (places < exp10.length) {
            return exp10[places];
        }
        long rval = this.getLongRange(places / 2);
        rval *= rval;
        if (places % 2 == 1) {
            rval *= 10L;
        }
        return rval;
    }

    private int getIntRange(int places) {
        if (places > 9) {
            places = 9;
        }
        return (int)this.getLongRange(places);
    }

    private int getShortRange(int places) {
        int range = this.getIntRange(places);
        if (range > Short.MAX_VALUE) {
            range = Short.MAX_VALUE;
        }
        return range;
    }

    private int getByteRange(int places) {
        int range = this.getIntRange(places);
        if (range > 127) {
            range = 127;
        }
        return range;
    }

    private int nextInt(int range) {
        return this.rand.nextInt(range);
    }

    private long nextLong(long range) {
        long rval = this.rand.nextLong();
        if (rval < 0L) {
            rval *= -1L;
        }
        return rval %= range;
    }

    public Boolean nextBoolean(boolean notnull) {
        return this.getNull(notnull) ? null : new Boolean(this.rand.nextBoolean());
    }

    public Byte nextbyte(boolean notnull, int places) {
        return this.getNull(notnull) ? null : new Byte((byte)this.nextInt(this.getByteRange(places)));
    }

    public Long nextlong(boolean notnull, int places) {
        return this.getNull(notnull) ? null : new Long(this.nextLong(this.getLongRange(places)));
    }

    public Integer nextint(boolean notnull, int places) {
        return this.getNull(notnull) ? null : new Integer(this.nextInt(this.getIntRange(places)));
    }

    public Short nextshort(boolean notnull, int places) {
        return this.getNull(notnull) ? null : new Short((short)this.nextInt(this.getShortRange(places)));
    }

    public Character nextCharacter(boolean notnull) {
        return this.getNull(notnull) ? null : new Character((char)(65 + this.nextInt(26)));
    }

    public Timestamp nextTimestamp(boolean notnull) {
        if (this.getNull(notnull)) {
            return null;
        }
        int range = 1000000;
        long atime = this.baseTime + (long)this.nextInt(1000000) - 500000L;
        return TimestampFactory.valueOf(atime);
    }

    public String nextString(boolean notnull, int length) {
        int MAX_STRING_LENGTH = 8000;
        if (this.getNull(notnull)) {
            return null;
        }
        if (length > 8000) {
            length = 8000;
        }
        int useLen = 1 + (1 + this.nextInt(3)) * ((length - 1) / 3);
        String rval = null;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < useLen; ++i) {
            int r = 65 + this.nextInt(26);
            buffer.append((char)r);
        }
        rval = buffer.toString();
        return rval;
    }

    public PrimitiveEnumeration nextEnum(boolean notnull, PrimitiveEnumeration[] values) {
        if (this.getNull(notnull)) {
            return null;
        }
        return values[this.nextInt(values.length)];
    }

    public <T> T nextClass(boolean notnull, T[] values) {
        if (this.getNull(notnull)) {
            return null;
        }
        return values[this.nextInt(values.length)];
    }

    public Object nextMapValue(boolean notnull, Map map) {
        if (this.getNull(notnull)) {
            return null;
        }
        Object[] keys = map.keySet().toArray();
        Object key = keys[this.nextInt(keys.length)];
        return map.get(key);
    }

    public BigDecimal nextDecimal(boolean notnull, int precision, int scale) {
        if (this.getNull(notnull)) {
            return null;
        }
        return BigDecimal.valueOf(this.nextLong(this.getLongRange(precision)), scale);
    }

    public int getNullRange() {
        return this.nullRange;
    }

    public void setNullRange(int nullRange) {
        this.nullRange = nullRange;
    }
}

