/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.util;

import com.objectriver.runtime.util.ArrayIterator;

public abstract class ArgumentParser {
    private String[] args;

    protected abstract Config[] getOptions();

    public ArgumentParser(String[] args) {
        this.args = args;
    }

    public void parse() throws SyntaxException {
        ArrayIterator arguments = new ArrayIterator(this.args);
        this.parseArgs(arguments);
        String[] newlist = null;
        Config[] options = this.getOptions();
        for (int ii = 0; ii < options.length; ++ii) {
            if (options[ii].list == null || options[ii].list.length == options[ii].numberArgs) continue;
            newlist = new String[options[ii].numberArgs];
            System.arraycopy(options[ii].list, 0, newlist, 0, options[ii].numberArgs);
            options[ii].list = newlist;
        }
    }

    public boolean isSet(String key) {
        return this.getConfig((String)key).found;
    }

    public String getValue(String key) {
        return this.getConfig((String)key).list[0];
    }

    public String[] getValues(String key) {
        return this.getConfig(key).getList();
    }

    public Config getConfig(String key) {
        Config[] options = this.getOptions();
        for (int ii = 0; ii < options.length; ++ii) {
            if (key.length() < options[ii].option.length() || !(options[ii].caseSensitive ? options[ii].option.equals(key.substring(0, options[ii].option.length())) : options[ii].option.equalsIgnoreCase(key.substring(0, options[ii].option.length())))) continue;
            return options[ii];
        }
        return null;
    }

    private void parseArgs(ArrayIterator arguments) throws SyntaxException {
        boolean again = arguments.hasNext();
        if (again) {
            arguments.next();
        }
        block0: while (again) {
            String additional;
            Config config;
            String option = (String)arguments.current();
            if (option.charAt(0) == '-') {
                config = this.getConfig(option.substring(1, option.length()));
                if (config == null) {
                    throw new SyntaxException("Error: Invalid option \"" + option + "\"");
                }
                config.setFound(true);
                if (config.concat) {
                    config.setList(option.substring(1 + config.option.length()));
                } else {
                    while (config.numberArgs < config.maxArgs && arguments.hasNext()) {
                        additional = (String)arguments.next();
                        if (additional.charAt(0) == '-') continue block0;
                        config.setList(additional);
                    }
                }
            } else {
                config = this.getOptions()[0];
                config.setFound(true);
                if (config.numberArgs >= config.maxArgs) {
                    throw new SyntaxException("Max args exceeded");
                }
                config.setList(option);
                while (config.numberArgs < config.maxArgs && arguments.hasNext()) {
                    additional = (String)arguments.next();
                    if (additional.charAt(0) == '-') continue block0;
                    config.setList(additional);
                }
            }
            if (!(again = arguments.hasNext())) continue;
            arguments.next();
        }
    }

    public class Config {
        public String option;
        public boolean concat;
        public boolean caseSensitive;
        public int minArgs;
        public int maxArgs;
        public int numberArgs;
        public boolean found;
        public String[] list;
        public String[] exclusions;

        public String getOption() {
            return this.option;
        }

        public void setOption(String option) {
            this.option = option;
        }

        public boolean isConcat() {
            return this.concat;
        }

        public void setConcat(boolean concat) {
            this.concat = concat;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public int getMinArgs() {
            return this.minArgs;
        }

        public void setMinArgs(int minArgs) {
            this.minArgs = minArgs;
        }

        public int getMaxArgs() {
            return this.maxArgs;
        }

        public void setMaxArgs(int maxArgs) {
            this.maxArgs = maxArgs;
        }

        public int getNumberArgs() {
            return this.numberArgs;
        }

        public void setNumberArgs(int numberArgs) {
            this.numberArgs = numberArgs;
        }

        public boolean isFound() {
            return this.found;
        }

        public void setFound(boolean found) {
            this.found = found;
        }

        public String[] getList() {
            return this.list;
        }

        public void setList(String entry) {
            if (this.list == null) {
                this.list = new String[this.maxArgs];
                this.list[0] = entry;
                ++this.numberArgs;
                return;
            }
            this.list[this.numberArgs++] = entry;
        }

        public String[] getExclusions() {
            return this.exclusions;
        }

        public void setExclusions(String[] exclusions) {
            this.exclusions = exclusions;
        }

        public Config(String option, boolean concat, boolean caseSensitive, int minArgs, int maxArgs, String[] exclusions) {
            this.option = option;
            this.concat = concat;
            this.caseSensitive = caseSensitive;
            this.minArgs = minArgs;
            this.maxArgs = maxArgs;
            this.exclusions = exclusions;
            this.numberArgs = 0;
            this.found = false;
            this.list = null;
        }
    }

    public static class SyntaxException
    extends Exception {
        public SyntaxException(String message) {
            super(message);
        }
    }
}

