/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.util;

import java.lang.reflect.Array;

public class ArrayHelper {
    public static Object[] add(Object[] one, Object[] two) {
        if (one == null || one.length == 0) {
            return two;
        }
        if (two == null || two.length == 0) {
            return one;
        }
        Object combined = Array.newInstance(one.getClass().getComponentType(), one.length + two.length);
        System.arraycopy(one, 0, combined, 0, one.length);
        System.arraycopy(two, 0, combined, one.length, two.length);
        return (Object[])combined;
    }

    public static void copy(Object[] target, Object[] source) {
        if (target == null) {
            throw new RuntimeException("ArrayHelper.copy() target[] is null?");
        }
        if (source == null) {
            throw new RuntimeException("ArrayHelper.copy() source[] is null?");
        }
        int trgtSize = target.length;
        int srcSize = source.length;
        if (trgtSize < srcSize) {
            throw new RuntimeException("ArrayHelper.copy() target[" + trgtSize + "] smaller then source[" + srcSize + "] array");
        }
        if (target.getClass() != source.getClass()) {
            throw new RuntimeException("ArrayHelper.copy() target[] class not equal to source[] class.");
        }
        for (int ii = 0; ii < srcSize; ++ii) {
            target[ii] = source[ii];
        }
    }

    public static Object[] resize(Object[] one, int newsize) {
        int oldsize = one.length;
        if (oldsize == newsize) {
            return one;
        }
        Object combined = Array.newInstance(one.getClass().getComponentType(), newsize);
        if (oldsize != 0) {
            if (newsize < one.length) {
                System.arraycopy(one, 0, combined, 0, newsize);
            } else {
                System.arraycopy(one, 0, combined, 0, one.length);
            }
        }
        return (Object[])combined;
    }

    public static Object[] recast(Class clazz, Object[] one) {
        Object two = Array.newInstance(clazz, one.length);
        System.arraycopy(one, 0, two, 0, one.length);
        return (Object[])two;
    }

    public static int removeGaps(Object[] array) {
        int size = array.length;
        int lastnil = -1;
        int length = 0;
        for (int ii = 0; ii < size; ++ii) {
            if (array[ii] == null) {
                if (lastnil != -1) continue;
                lastnil = ii;
                continue;
            }
            ++length;
            if (lastnil == -1) continue;
            array[lastnil] = array[ii];
            array[ii] = null;
            while (array[lastnil] != null && lastnil < size) {
                ++lastnil;
            }
        }
        return length;
    }
}

