/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.runtime.util;

import com.objectriver.runtime.primitives.StringConst;
import com.objectriver.runtime.util.CurrentIterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements CurrentIterator {
    private final Object[] array;
    private int current = 0;

    public ArrayIterator(Object[] array) {
        this.array = array == null ? StringConst.emptyStringArray : array;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.array.length;
    }

    public Object next() {
        if (this.current > this.array.length) {
            throw new NoSuchElementException("No more Array elements!");
        }
        return this.array[this.current++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Array is immutable!");
    }

    @Override
    public Object current() {
        if (this.current == 0) {
            return this.next();
        }
        return this.array[this.current - 1];
    }
}

